/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.UFOCarrier;
import OreSpawn.entities.UFOFighter;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Martian;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class UFO
extends EntityLiving {
    public float myspeed = 0.0f;
    public float newangle = 0.0f;
    public int[] blinker = new int[8];

    public UFO(World w) {
        super(w);
        this.maxrenderdist = 300;
        this.uniquename = "OreSpawn:UFO";
        if (w != null) {
            this.myspeed = 0.15f + this.world.rand.nextFloat() * 0.05f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 4.0f;
        this.width = 16.0f;
        this.setMaxHealth(500.0f);
        this.setHealth(500.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(100.0f);
        this.searchDistance = 190.0f;
        this.attackRange = 3.5f;
        this.temperament = 2;
        this.enable_hostile = true;
        this.canFly = true;
        this.setFlying(true);
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
        int i = 0;
        while (i < 8) {
            this.blinker[i] = 0;
            ++i;
        }
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
    }

    public float getNewangle() {
        this.newangle += 0.1f;
        while (this.newangle > 360.0f) {
            this.newangle -= 360.0f;
        }
        return (float)Math.toRadians(this.newangle);
    }

    public boolean getBlink(int i) {
        int n = i;
        this.blinker[n] = this.blinker[n] + 1;
        if (this.blinker[i] < 60 + i / 2) {
            return false;
        }
        if (this.blinker[i] >= 120 + i) {
            this.blinker[i] = 0;
        }
        return true;
    }

    public void doEntityAction(float deltaT) {
        int bid;
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            if (this.hurtMe != null && !this.isSuitableTarget(this.hurtMe)) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, 200.0, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(20) == 1) {
            Entity e;
            String what = "OreSpawn:UFO Fighter";
            if (this.world.rand.nextInt(3) == 1) {
                what = "OreSpawn:UFO Carrier";
            }
            if ((e = this.world.createEntityByName(what, this.dimension, this.posx, this.posy - 5.0, this.posz)) != null) {
                e.init();
                this.world.spawnEntityInWorld(e);
            }
        }
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(200) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 35;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy + 1.0, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0) {
            int i = 0;
            while (i < 4) {
                if (this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)i, this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                    bid = 1;
                }
                ++i;
            }
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                this.target.setTarget(this.posx + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35), (double)(200 + (this.world.rand.nextInt(7) - this.world.rand.nextInt(7))), this.posz + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.15f + this.world.rand.nextFloat() * 0.05f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.1f) {
            dy = 0.1f;
        }
        if (dy < (double)-0.1f) {
            dy = -0.1f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        this.rotation_yaw_motion = 0.0f;
        this.rotation_yaw = 0.0f;
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Martian) {
            return false;
        }
        if (e instanceof UFO) {
            return false;
        }
        if (e instanceof UFOCarrier) {
            return false;
        }
        if (e instanceof UFOFighter) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int i = 0;
        while (i < 200) {
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.dark.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.light.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.instability.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpcopper.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumptin.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpsilver.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpplatinum.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.laserball.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.raygun.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockcopper.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocktin.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocksilver.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockplatinum.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/UFOtexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:dragonfly_hurt";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "DangerZone:large_explosion1";
        }
        if (which == 1) {
            return "DangerZone:large_explosion2";
        }
        return "DangerZone:large_explosion3";
    }

    public String getLivingSound() {
        int which = this.world.rand.nextInt(17);
        if (which == 0) {
            return "OreSpawn:hover1";
        }
        if (which == 1) {
            return "OreSpawn:hover2";
        }
        if (which == 2) {
            return "OreSpawn:hover3";
        }
        if (which == 3) {
            return "OreSpawn:hover4";
        }
        if (which == 4) {
            return "OreSpawn:hover5";
        }
        if (which == 5) {
            return "OreSpawn:hover6";
        }
        if (which == 6) {
            return "OreSpawn:robotspider1";
        }
        if (which == 7) {
            return "OreSpawn:robotspider2";
        }
        if (which == 8) {
            return "OreSpawn:robotspider3";
        }
        if (which == 9) {
            return "OreSpawn:robotspider4";
        }
        if (which == 10) {
            return "OreSpawn:robotspider5";
        }
        if (which == 11) {
            return "OreSpawn:robotspider6";
        }
        if (which == 12) {
            return "OreSpawn:robotspider7";
        }
        if (which == 13) {
            return "OreSpawn:robotspider8";
        }
        if (which == 14) {
            return "OreSpawn:robotspider9";
        }
        if (which == 15) {
            return "OreSpawn:robotspider10";
        }
        if (which == 16) {
            return "OreSpawn:robotspider11";
        }
        return null;
    }

    public void setBaby(boolean tf) {
    }
}

